/***************************************************************************
 *   Copyright (C) 2008 by Manuel Schrape                                  *
 *   manuel.schrape@gmx.de                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License.        *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include <QStringList>

#include "cKML_Server.h"

cKML_Server::cKML_Server()
{
    NaviCount = 0;
}

void cKML_Server::start_Server(int Port, cSettings *Set)
{
    Settings = Set;

    TcpServer = new QTcpServer();
    if (!TcpServer->listen(QHostAddress::Any, qint16(Port)))
    {
        qDebug("Kann Serversocket nicht Einrichten..!!");
    }
    else
    {
        connect(TcpServer, SIGNAL(newConnection()), this, SLOT(slot_NewConnection()));
    }
}

void cKML_Server::stop_Server()
{
    delete TcpServer;
}

void cKML_Server::store_NaviString(sNaviString Navi)
{
    Route[NaviCount] = Navi;
    NaviCount++;
}

void cKML_Server::slot_ReadData()
{
    if (TcpSocket->canReadLine())
    {
        QStringList tokens = QString(TcpSocket->readLine()).split(QRegExp("[ \r\n][ \r\n]*"));

        qDebug() << "QStringList ---------";
        for (QList<QString>::iterator i = tokens.begin(); i != tokens.end(); ++i)
            qDebug() << (*i);
    }

    TcpSocket->close();
}

void cKML_Server::slot_NewConnection()
{
    TcpSocket = TcpServer->nextPendingConnection();
    connect(TcpSocket, SIGNAL(readyRead ()),this, SLOT(slot_ReadData()));

    QByteArray block;

    block = "HTTP/1.0 200 OK\nContent-Type: application/vnd.google-earth.kml+xml; charset=iso-8859-1\nConnection: close\n\n";
//    block = "HTTP/1.0 200 OK\nContent-Type: text/xml; charset=utf-8\nConnection: close\n\n";

    TcpSocket->write(block);

    TcpSocket->write(get_KML());

    TcpSocket->close();
}

QByteArray cKML_Server::get_KML()
{
    QByteArray block;

    block = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n"
            "<kml xmlns=\"http://earth.google.com/kml/2.2\">\n"
            "  <Document>\n"
            "    <name>Online Mikrokopter GPS Position</name>\n"
            "    <Style id=\"MK_gps-style\">\n"
            "      <LineStyle>\n"
            "        <color>ff0000ff</color>\n"
            "        <width>2</width>\n"
            "      </LineStyle>\n"
            "    </Style>\n"
            "    <Placemark>\n"
            "      <LookAt>\n"
            "        <range>400</range>\n"
            "        <tilt>45</tilt>\n"
            "      </LookAt>\n"
            "      <name>Flight</name>\n"
            "      <styleUrl>#MK_gps-style</styleUrl>\n"
            "      <LineString>\n";
    if (Settings->Server.ToGround)
    {
        block = block + "        <extrude>1</extrude>\n";
    }

    block = block +
            "        <tessellate>1</tessellate>\n"
            "        <altitudeMode>relativeToGround</altitudeMode>\n"
            "        <coordinates>\n";

    for (int a = 0; a < NaviCount; a++)
    {
        block = block + Route[a].Longitude.toLatin1() + "," + Route[a].Latitude.toLatin1() + "," + Route[a].Altitude.toLatin1() + " " ;
        block = block + "\n";
    }

    block = block +
            "        </coordinates>\n"
            "      </LineString>\n"
            "    </Placemark>\n"
            "  </Document>\n"
            "  </kml>\n";

        return block;
}

cKML_Server::~cKML_Server()
{
}
